using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Mail;
using System.Net;

namespace PI.ZB.N1201.BaseCMS.BL
{
    public class Feedback : BaseCMS
    {
        public Feedback(Gemini.Core.BL.Interface.IEnvironment Environment)
            : base(Environment)
        {

        }

        #region Name, ClientID
        public override string Name
        {
            get { return Dictionary.PLUGIN_NAME; }
        }

        public override long ClientID
        {
            get { return Dictionary.Clients.Feedback_PlugIn; }
        }
        #endregion

        /// <summary>
        /// Wysya email typu Feedback - kontakt ze strony WWW od przypadkowego kogos
        /// </summary>
        /// <param name="Name"></param>
        /// <param name="Email"></param>
        /// <param name="Message"></param>
        /// <returns></returns>
        /// 
        public bool SendEmail(string Name, string Email, string Message)
        {
            try
            {
                SmtpClient client = new SmtpClient(this.Description.Params[Dictionary.Params.FeedbackEmail.Server].Value, 25);
                client.UseDefaultCredentials = false;
                client.Credentials = new NetworkCredential(this.Description.Params[Dictionary.Params.FeedbackEmail.User].Value, this.Description.Params[Dictionary.Params.FeedbackEmail.Password].Value);


                StringBuilder _sbMessage = new StringBuilder();
                _sbMessage.AppendLine("Witaj,");
                _sbMessage.AppendLine();
                _sbMessage.AppendLine(this.Description.Params[Dictionary.Params.FeedbackEmail.Subject].Value);
                _sbMessage.AppendLine();
                _sbMessage.AppendLine("Imi, nazwisko: " + Name);
                _sbMessage.AppendLine("Email: " + Email);
                _sbMessage.AppendLine();
                _sbMessage.AppendLine("Tre wiadomoci:");
                _sbMessage.AppendLine();
                _sbMessage.AppendLine(Message);
                _sbMessage.AppendLine();

                using (MailMessage msg = new MailMessage())
                {
                    msg.From = new MailAddress(this.Description.Params[Dictionary.Params.FeedbackEmail.FromEmail].Value, this.Description.Params[Dictionary.Params.FeedbackEmail.FromName].Value);
                    msg.Subject = this.Description.Params[Dictionary.Params.FeedbackEmail.Subject].Value;
                    msg.Body = _sbMessage.ToString();
                    msg.To.Add(new MailAddress(this.Description.Params[Dictionary.Params.FeedbackEmail.ToEmail].Value));
                    msg.CC.Add(new MailAddress(Email));
                    msg.ReplyTo = new MailAddress(Email);
                    client.Send(msg);
                }
            }
            catch (Exception Except)
            {
                Gemini.Utility.Debug.SendExeptionViaEmali(Environment.ProjectName,Except, String.Format("BL: {0}, Method: {1}", this.Name, "SendEmail"));
                return false;
            }
            return true;
        }
    }
}
